package org.msh.tb.bd.dashboard.query;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;

import java.util.List;

/**
 * Created by Mauricio on 08/05/2017.
 */
public class Indicator03Query extends IndicatorQuery {

    @Override
    public Float calculateRate(Object[] o) {
        Long population = (Long) o[1];
        Long caseQtt = (Long) o[2];

        return DashboardIndicatorUtils.calcPopulationRate(caseQtt, population);
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new TB cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au.name.name1, " +
                "(select sum(p.population) " +
                    "from Population p " +
                    "where p.adminUnit.code like concat(au.code,'%') and p.year = :year " +
                    "and p.adminUnit.workspace.id = :wsId), " +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.patientType = 0 " +
                    "and p.workspace.id = :wsId)" +
                "from AdministrativeUnit au " +
                "where au.workspace.id = :wsId " + adminUnitCondition +
                " and (select count(*) " + // same subquery as above
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.patientType = 0 " +
                    "and p.workspace.id = :wsId) > 0" +
                "order by au.name.name1")
                .setParameter("year", getIniYear())
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }
}
